//  (function(exports) {
//      exports.main = function() {
//          /.../ // some executable code
//      }
//  })(this.app_sw = {})

(function(exports) {
    exports.main = async function() {
        const app_sw_control_script = utils.load_script('app_sw_control.js')
        const heat_line_common_script = utils.load_script('heat_line_common.js')
        const network_settings_script = utils.load_script('app_sw_config.js')
        const localization_script = utils.load_script('localization.js')
        await Promise.all([
            app_sw_control_script,
            heat_line_common_script,
            network_settings_script,
            localization_script
        ])
        .then(() => app_sw_control.main())
        .then(() => heat_line_common.request_control_mode(app_sw_config.heat_lines_count))
        .then(control_mode => {
            localization.main()
            app_sw_config.add_configuration()
            heat_line_common.show(control_mode)
        })
    }
    
})(this.app_sw = {})
